#!/bin/bash
# RonsTechHub
# Debian 13 (Trixie) Upgrade Script for Raspberry Pi
# ---------------------------------------------------
# This script backs up all APT sources, updates them to Trixie,
# then upgrades the entire system safely.

set -e  # Stop if any command fails

echo "=== Debian 13 (Trixie) Upgrade Script ==="
echo "Brought to you by <RonsTechHub> <www.RonsTechHub.com> <RonsTechHub on all socials>."
echo "Starting backup and upgrade process..."
echo

# Step 1: Create backup directory
BACKUP_DIR="/etc/apt/sources_backup_$(date +%Y%m%d_%H%M%S)"
echo "Creating backup directory at: $BACKUP_DIR"
sudo mkdir -p "$BACKUP_DIR"

# Step 2: Backup current source list files
echo "Backing up APT source files..."
sudo cp -v /etc/apt/sources.list "$BACKUP_DIR"/
sudo cp -v /etc/apt/sources.list.d/*.list "$BACKUP_DIR"/ 2>/dev/null || true

# Step 3: Confirm backup
echo "Backup complete. Files saved in: $BACKUP_DIR"
echo

# Step 4: Replace bookworm/bullseye with trixie
echo "Updating APT sources to Debian 13 (Trixie)..."
sudo sed -i 's/bookworm/trixie/g; s/bullseye/trixie/g' /etc/apt/sources.list /etc/apt/sources.list.d/*.list 2>/dev/null || true
echo "Sources updated."
echo

# Step 5: Update APT and minimal upgrade
echo "Updating package lists..."
sudo apt update -y

echo "Performing minimal upgrade..."
sudo apt upgrade --without-new-pkgs -y
echo

# Step 6: Full distribution upgrade
echo "Performing full distribution upgrade..."
sudo apt full-upgrade -y
echo

# Step 7: Clean up old packages
echo "Cleaning up unused packages..."
sudo apt --purge autoremove -y
sudo apt clean
echo

# Step 8: Finished
echo "Upgrade complete! Debian 13 (Trixie) should now be installed."
echo "Rebooting system in 10 seconds..."
sleep 10
sudo reboot

# RonsTechHub